# wecloud-im服务端REST API对接文档

## 本地API文档地址

http://192.168.1.110:8082/api/doc.html#/home

账号密码admin admin

 以上只包含api接口文档  websocket对接说明在此文档中

## 测试外网

文档:

```
https://wstest.im199.com/api/doc.html#/home
```

___

测试外网请求示例:

```
https://wstest.im199.com/api/imApplication/add
```



_______



## 生产环境

ws.im199.com

文档:

```
https://ws.im199.com/api/doc.html#/home
```

___

测试外网请求示例:

```
https://ws.im199.com/api/imApplication/add
```


_______





## 鉴权方式

### 方式一(正在开发):

对于 POST 和 PUT 请求，请求的主体必须是 JSON 格式，而且 HTTP header 的 Content-Type 需要设置为 `application/json`。

用户验证通过 HTTP header 来进行，**appkey** 标明正在运行的是哪个应用（应用的 App ID）， **appSecret** 用来授权鉴定 endpoint：



**示例**: rest-api-会话成员表分页列表

- Request URL: http://192.168.1.89:8082/api/restApi/imConversationMembers/findList

- Request Method: POST

**请求头部**

```
appkey: D13ug9jsWbJbeVx1

appSecret: c92edcc7ba0c68b9b1da4cec6f3511876b2302faf2ab3737
```



**请求body**

```
{
	"conversationId": 1442742976269914112
}
```



**响应数据**

```
{"code":200,"message":"成功","data":[{"clientId":"1442742442803503105"},{"clientId":"1435497966619996162"}]}
```



### 方式二(暂时没开发)

**更安全的鉴权**

我们还支持一种新的 API 鉴权方式，即在 HTTP header 中使用 **X-LC-Sign** 来代替 **X-LC-Key**，以降低 App Key 的泄露风险。例如：

```json
curl -X PUT \
  -H "X-LC-Id: {{appid}}" \
  -H "X-LC-Sign: d5bcbb897e19b2f6633c716dfdfaf9be,1453014943466" \
  -H "Content-Type: application/json" \
  -d '{"content": "在 HTTP header 中使用 X-LC-Sign 来更新一篇博客的内容"}' \
  https://https://ws.im199.com/api/
```

**X-LC-Sign** 的值是由 `sign,timestamp` 组成的字符串：

| 取值      | 约束 | 描述                                                         |
| :-------- | :--- | :----------------------------------------------------------- |
| sign      | 必须 | 将 timestamp 加上 App Key 组成的字符串，再对它做 MD5 签名后的结果。 |
| timestamp | 必须 | 客户端产生本次请求的 unix 时间戳（UTC），精确到**毫秒**。    |



举例来说，假设应用的信息如下：

| App Id     | `FFnN2hso42Wego3pWq4X5qlu`        |
| ---------- | --------------------------------- |
| App Key    | `UtOCzqb67d3sN12Kts4URwy8`        |
| 请求时间   | 2016-01-17 15:15:43.466 GMT+08:00 |
| timestamp  | `1453014943466`                   |

**使用 App Key 来计算(MD5) sign**：

```sh
  -H "X-LC-Sign: d5bcbb897e19b2f6633c716dfdfaf9be,1453014943466" \
```

## 响应格式

对于所有的请求，响应格式都是一个 JSON 对象。

一个请求是否成功是由 HTTP 状态码标明的。一个 2XX 的状态码表示成功，而一个 4XX 表示请求失败。当一个请求失败时响应的主体仍然是一个 JSON 对象，但是总是会包含 `code` 和 `error` 这两个字段，你可以用它们来进行调试。举个例子，如果尝试用非法的属性名来保存一个对象会得到如下信息：

## 单聊、群聊

### 创建对话

### 查询对话

### 更新对话

### 删除对话

### 增加成员

### 移除成员

### 查询成员

### 单聊、群聊-发消息

### 查询历史消息

### 单聊、群聊-修改消息

### 单聊、群聊-撤回消息



## 黑名单

### 增加对话黑名单

### 移除对话黑名单

### 查询对话黑名单
